/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.TextComponent;
import java.net.URL;

class Animation
extends Canvas
implements Runnable {
    static boolean european = false;
    control p;
    URL base;
    Image redLight;
    Image greenLight;
    Image yellowLight;
    Image redCar;
    Image Light;
    int delay;
    movingCar A;
    Dimension area;
    double v = 0.0;
    double a = 0.0;
    double t = 0.0;
    boolean deleted = true;
    boolean erase = false;
    int count;
    int randomCount;
    int x0 = 80;
    Thread animThread;
    long startTime = 0L;
    long lastTime;
    long conditionTime;
    long delta;
    boolean condition = true;
    boolean yellowOff = true;
    boolean running = false;
    int xs = 0;
    int ys;
    boolean drag = false;
    boolean showXY = true;
    double delayTime;
    boolean moved = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void init() {
        this.delay = 50;
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(this.greenLight, 0);
        mediaTracker.addImage(this.yellowLight, 1);
        mediaTracker.addImage(this.redLight, 2);
        mediaTracker.addImage(this.redCar, 3);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
        }
        this.A = new movingCar(0, this.v, this.redCar, this.redCar.getWidth(this), this.redCar.getHeight(this));
    }

    public void reset(boolean bl) {
        this.area = this.size();
        this.Light = this.greenLight;
        Graphics graphics = this.getGraphics();
        this.clear(graphics);
        String string = european ? this.p.TextF.getText().replace(',', '.') : this.p.TextF.getText();
        this.a = -9.8 * Double.valueOf(string.trim());
        this.A.init(this.area, 2, this.v);
        this.A.acceleration(0.0);
        this.randomCount = (int)(Math.random() * 100.0 + (double)this.x0 + 50.0);
        this.count = 0;
        this.condition = false;
        this.A.drawCar(graphics, this.condition);
    }

    void drawLight(Graphics graphics, Image image) {
        if (image != null) {
            graphics.drawImage(image, this.area.width - 2 * image.getWidth(this), 20, Color.white, this);
        }
    }

    void start() {
        if (this.animThread == null) {
            this.animThread = new Thread(this);
            this.animThread.start();
            this.lastTime = this.startTime = System.currentTimeMillis();
        }
    }

    public void stop() {
        this.animThread = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Thread.currentThread().setPriority(1);
        Graphics graphics = this.getGraphics();
        while (Thread.currentThread() == this.animThread) {
            this.startTime += (long)this.delay;
            this.delta = System.currentTimeMillis() - this.lastTime;
            if (this.running) {
                this.advanced((double)this.delta / 1000.0);
            }
            this.lastTime += this.delta;
            try {
                Thread.sleep(Math.max(0L, this.startTime - System.currentTimeMillis()));
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    void advanced(double d) {
        if (!this.condition) {
            if (this.A.x > this.randomCount) {
                this.condition = true;
                this.conditionTime = System.currentTimeMillis();
                this.Light = this.redLight;
            } else if (this.yellowOff && this.A.x > this.x0) {
                this.Light = this.yellowLight;
                this.yellowOff = false;
            }
        }
        this.moved = this.A.move(d);
        this.repaint();
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (!this.drag) {
            this.xs = n;
            this.ys = n2;
        }
        this.writeText(n, n2);
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        this.writeText(n - this.xs, n2 - this.ys);
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        this.writeText(n, n2);
        this.drag = false;
        return true;
    }

    String d2String(double d) {
        float f = (float)((double)((int)(100.0 * d)) / 100.0);
        String string = String.valueOf(f);
        if (string.indexOf(".") == -1) {
            string = string + ".0";
        } else if (string.length() - string.indexOf(".") == 2) {
            string = string + "0";
        }
        if (european) {
            return string.replace('.', ',');
        }
        return string;
    }

    void writeText(int n, int n2) {
        ((TextComponent)this.p.mouseP).setText("X=" + this.d2String((double)n / this.A.scale) + "m,V=" + this.d2String((double)(this.area.height - n2) / this.A.scale) + "m/s");
    }

    public boolean mouseMove(Event event, int n, int n2) {
        if (this.showXY) {
            this.writeText(n, n2);
        }
        return true;
    }

    public void brake() {
        if (this.animThread != null) {
            this.A.acceleration(this.a);
            if (this.condition) {
                long l = System.currentTimeMillis();
                this.delayTime = (double)(l - this.conditionTime) / 1000.0;
                ((TextComponent)this.p.TextT).setText(this.d2String(this.delayTime) + " + " + this.d2String((double)((int)(-this.v * 1000.0 / this.a)) / 1000.0) + " sec");
                this.A.markV(this.getGraphics(), this.area.height, this.delayTime);
            }
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, this.area.width - 1, this.area.height - 1);
        this.A.drawHistory(graphics);
        this.drawLight(graphics, this.Light);
        this.update(graphics);
    }

    void clear(Graphics graphics) {
        int n;
        int n2;
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.area.width, this.area.height);
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, this.area.width - 1, this.area.height - 1);
        int n3 = 0;
        double d = 5.0 * this.A.scale;
        double d2 = d * 2.0;
        graphics.setColor(Color.red);
        double d3 = this.area.height;
        while (d3 > 0.0) {
            n2 = (int)d3;
            graphics.drawLine(0, n2, 10, n2);
            graphics.drawString(this.d2String(n3), 12, n2);
            n3 += 10;
            n = 1;
            while (n < 10) {
                n2 = (int)(d3 - (double)n * this.A.scale);
                graphics.drawLine(0, n2, 2, n2);
                ++n;
            }
            n2 = (int)(d3 - d);
            graphics.drawLine(0, n2, 5, n2);
            d3 -= d2;
        }
        graphics.drawString("V(m/s)", 45, 40);
        graphics.setColor(Color.black);
        n3 = 0;
        d3 = 0.0;
        while (d3 < (double)this.area.width) {
            n2 = (int)d3;
            graphics.drawLine(n2, 0, n2, 10);
            graphics.drawString(this.d2String(n3), n2, 20);
            n3 += 10;
            n = 1;
            while (n < 9) {
                n2 = (int)(d3 + (double)n * this.A.scale);
                graphics.drawLine(n2, 0, n2, 2);
                ++n;
            }
            n2 = (int)(d3 + d);
            graphics.drawLine(n2, 0, n2, 5);
            d3 += d2;
        }
    }

    public void update(Graphics graphics) {
        graphics.setColor(this.getBackground());
        this.drawLight(graphics, this.Light);
        if (this.running && this.A.resetX(this.area.width)) {
            this.clear(graphics);
            this.drawLight(graphics, this.Light);
        }
        if (this.condition) {
            graphics.setColor(Color.red);
        } else {
            graphics.setColor(Color.black);
        }
        this.A.drawCar(graphics, true);
        this.A.drawV(graphics, this.area.height);
        if (this.running && !this.moved) {
            double d = this.v * this.v / (2.0 * this.a);
            graphics.drawString(this.d2String(-d) + "m", this.A.x + 10, this.area.height - 40);
            graphics.drawString("+ " + this.d2String(this.v * this.delayTime) + "m     =    " + this.d2String(this.v * this.delayTime - d) + "m", this.A.x + 90, this.area.height - 40);
            this.running = false;
        }
    }

    Animation(Applet applet, String[] stringArray) {
        this.setBackground(Color.white);
        if (applet != null) {
            this.base = applet.getCodeBase();
            this.greenLight = applet.getImage(this.base, "greenLight.gif");
            this.yellowLight = applet.getImage(this.base, "yellowLight.gif");
            this.redLight = applet.getImage(this.base, "redLight.gif");
            this.redCar = applet.getImage(this.base, "redCar.gif");
        } else {
            this.greenLight = this.getToolkit().getImage("greenLight.gif");
            this.redLight = this.getToolkit().getImage("redLight.gif");
            this.yellowLight = this.getToolkit().getImage("yellowLight.gif");
            this.redCar = this.getToolkit().getImage("redCar.gif");
        }
        this.init();
    }
}

